/*------------------------------------------------------------------------------*
 * File Name:PESplitter, Project Explorer Control								*
 * Creation: CPY Feb 23 2004													*
 * Purpose: A Splitter Control that support the current project's pages			*
 * Copyright (c) Originlab Corp., 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Frank 	05/13/04 v8.0872 ADD_FLAG_SEACH_FOLDER								*
 *	Jasmine 10/28/05 v8.0324 SPLITTER_INIT_SIZE_ON_READY						*
 *------------------------------------------------------------------------------*/
#ifndef _PE_CONTROL_H
#define _PE_CONTROL_H

#include "PageListControl.h"
#define WM_USER_ON_PAGE_CHANGE	(WM_USER + 789)

class PEPages : public PageListControl
{
public:
	void Init(int nID, WndContainer& dlg, LPCSTR lpcszDlgName)
	{
		PageListControl::Init(nID, dlg, lpcszDlgName);
		m_nId = nID;
	}
	bool UpdateList(Folder& fldr)
	{
		ClearAll();
		if(!fldr.IsValid())
			return false;
		
		AddPages(fldr);
		ResizeCols(3, 1);
		return true;
	}
	bool GetSelectedPage(string& strPage)
	{
		int nSel = GetSelectedRow();
		if(nSel < 0)
			return false;
		strPage = GetCell(flexcpText, nSel, PEPAGE_SHORTNAME);
		return true;
	}
private:
	int 	m_nId; // child ID of control, may not be needed
};

class PEFolders : public GridTreeControl
{
public:
	void Init(int nID, WndContainer& dlg)
	{
		GridTreeControl::Init(nID, dlg);
		m_nId = nID;
		//m_flx.FocusRect = flexFocusHeavy;
		//m_flx.HighLight = flexHighlightWithFocus;
		//m_flx.SelectionMode = flexSelectionListBox;
		////////////////////////////////////////////
		tree_get_project_folders_and_pages(m_PEFolders);
		//AddTreeNodes(m_PEFolders, ATRN_SKIP_LEAFS); // show only folders
		//AddTreeNodes(m_PEFolders, -1, NULL, true, true); // show only folders ///DG 4/21/05 REWRITE_TREE_GET_NODE
		AddTreeNodes(m_PEFolders, ATRN_SKIP_LEAFS);
	}
	Folder GetSelectedFolder()
	{
		Folder fldrInvalid;
		int nSel = GetSelectedRow();
		if(nSel >= 0)
		{
			///Frank 	05/13/04 v8.0872 ADD_FLAG_SEACH_FOLDER
			//TreeNode trNode = get_tree_node(nSel);
			TreeNode trNode = get_tree_node(nSel, true);
			///End ADD_FLAG_SEACH_FOLDER
			string strPath;
			trNode.GetAttribute(STR_PATH_ATTRIB, strPath);
			Folder fldr1(strPath);
			return fldr1;
		}
		return fldrInvalid;
	}
private:
	///Frank 	05/13/04 v8.0872 ADD_FLAG_SEACH_FOLDER
	//TreeNode get_tree_node(int nRow)
	//{
		//int nIndex = nRow - m_flx.FixedRows;
		//return tree_get_sel_node(m_PEFolders, nIndex); // TD 3-31-04
	//}
	TreeNode get_tree_node(int nRow,bool bFolderOnly = false )
	{
		int nIndex = nRow - m_flx.FixedRows;
		return tree_get_sel_node(m_PEFolders, nIndex,bFolderOnly); 
	}
	
	TreeNode tree_get_sel_node(TreeNode &tr, int nRow, bool bFolderOnly = false ,int* lpInc = NULL)
	{
		TreeNode cNode = tr.FirstNode;
		if(!cNode)
			return cNode;//NULL
		
		int nIndex = (lpInc)? *lpInc : 0;
		foreach(TreeNode trN in tr.Children)
		{
			int intFolderID;
			trN.GetAttribute(STR_DISPLAY_ATTRIB, intFolderID);
			if(nIndex == nRow)
			{
				if(bFolderOnly)
				{
					if( intFolderID == IDI_FOLDER_CLOSED||nIndex ==0 )
						return trN;
				}
				else
					return trN;
			}
			if(bFolderOnly )
			{
				if( intFolderID == IDI_FOLDER_CLOSED ||nIndex ==0 )
					nIndex++;
			}
			else
				nIndex++;
				
			if(trN.GetNodeCount() > 0) // branch node
			{
				cNode = tree_get_sel_node(trN, nRow, bFolderOnly, &nIndex);
				if(cNode)
					return cNode;
			}
			if(lpInc)
				*lpInc = nIndex;
		}
		TreeNode trJunk;
		return trJunk;
	}
	///End ADD_FLAG_SEACH_FOLDER
	
private:
	int 	m_nId; // child ID of control, may not be needed
	Tree	m_PEFolders;
};

#define PANE_ROW_COL_FOLDERS	0,0
#define PANE_ROW_COL_PAGES		0,1
// PEControl
// this control is similar to the Project Explorer on 
// Origin's main interface
class PESplitter : public SplitterControl
{
private:
	
public:
	PESplitter()
	{
		m_bReady = false;
		// control ID for panes
		// Must init these IDs before calls to InitMsgMap
		SetGridSize(1,2);
		m_IDfolders = GetDlgCtrlID(PANE_ROW_COL_FOLDERS);
		m_IDpages = GetDlgCtrlID(PANE_ROW_COL_PAGES);

		InitMsgMap();
	}
	void Init(int nCntrlID, WndContainer& wndParent, LPCSTR lpcszDlgName, bool bVisible = true)
	{
		m_strDlgName = lpcszDlgName;
		SplitterControl::Init(nCntrlID, wndParent, 1, lpcszDlgName);// 1 = 2nd splitter in dialog
		Visible = bVisible;
	}
	///Jasmine 10/28/05 v8.0324 SPLITTER_INIT_SIZE_ON_READY
	void OnReady()
	{
		SplitterControl::OnReady();
	}
	///End SPLITTER_INIT_SIZE_ON_READY
protected:
EVENTS_BEGIN
	ON_INIT(OnInitDialog)
	ON_DESTROY(OnDestroy)
	ON_SIZE(OnCtrlResize)
	ON_GRID_ROW_COL_CHANGE(m_IDfolders, OnChangeFolder)
	ON_GRID_ROW_COL_CHANGE(m_IDpages, OnChangePage)
	
EVENTS_END
	BOOL OnInitDialog()
	{
		m_bReady = false;
		GUID clsid; // later, for now, only vsFlex
		
		CreateActiveXPane(clsid, PANE_ROW_COL_FOLDERS);		
		m_folders.Init(m_IDfolders, *this);
		
		CreateActiveXPane(clsid, PANE_ROW_COL_PAGES);
		m_pages.Init(m_IDpages, *this, m_strDlgName);
		
		SetReady();
		m_bReady = true;
		return TRUE;
	}
	BOOL OnCtrlResize(int nType, int cx, int cy)
	{
		SplitterControl::OnResize(nType, cx, cy);
		return TRUE;
	}
	void OnChangeFolder(Control cntrl)
	{
		if(!m_bReady)
			return;
		//out_str("PE folder sel changes");
		Folder fldr = m_folders.GetSelectedFolder();
		m_pages.UpdateList(fldr);
	}	
	void OnChangePage(Control cntrl)
	{
		if(!m_bReady)
			return;
		
		Window Wnd = GetParent();
		if(Wnd)
			Wnd.PostMessage( WM_USER_ON_PAGE_CHANGE );

	}
public:
	bool GetSelectedPage(string& strPageName)
	{
		return m_pages.GetSelectedPage(strPageName);
	}
		
private:
	PEFolders  	m_folders;
	PEPages  	m_pages;
	int			m_IDfolders;// control ID for panes
	int			m_IDpages;
	string		m_strDlgName;
	bool		m_bReady;
};


#endif //_PE_CONTROL_H
